require( "scripts/style.lua" );

kButtonSpacing = 60;	-- Put our buttons 60 pixels apart
kButtonY = kCenter-70;	-- Three buttons means center 60 pixels above the center

-- Style for upgrades

UpgradeButtonGraphics = {
	"",
	"",
	"icons/genericselect"
};

UpgradeButtonStyle = {
	parent = DefaultStyle,
	font = StandardButtonFont,
	sound = kDefaultButtonSound,
	type= kPush,
	graphics = UpgradeButtonGraphics,
};

if gMode == "story" then
	options = prepareDecorOptions(gLevel);
else
	options = prepareDecorOptionsEndless();
end

images = {};
decor_upgrade = {};
for i = 1, options, 1 do
	images[i] = getDecorButton(i);
	decor_upgrade[i] = getDecorOption(i);
end 


StandardButtonFont2 = {
  standardFont,
  24,
  BlackColor
};
DecorButtonGraphics1 = {
	images[1],
	images[1],
	images[1]
};
DecorButtonStyle1 = {
	parent = DefaultStyle,
	font = StandardButtonFont,
	sound = kDefaultButtonSound,
	type= kPush,
	graphics = DecorButtonGraphics1,
};
DecorButtonGraphics2 = {
	images[2],
	images[2],
	images[2]
};
DecorButtonStyle2 = {
	parent = DefaultStyle,
	font = StandardButtonFont,
	sound = kDefaultButtonSound,
	type= kPush,
	graphics = DecorButtonGraphics2,
};
DecorButtonGraphics3 = {
	images[3],
	images[3],
	images[3]
};
DecorButtonStyle3 = {
	parent = DefaultStyle,
	font = StandardButtonFont,
	sound = kDefaultButtonSound,
	type= kPush,
	graphics = DecorButtonGraphics3,
};

--DebugOut("I've been called******************");
--DebugOut("options:"..options);


------ define Y-alignment positions -------
graphicElementsY = kButtonY + 30;
textElementsY    = graphicElementsY + 130 ;
starsPosY        = graphicElementsY - 80;
---------------------------------------------------

decorLevel_1 = getDecorUpgradeCount(1);
decorLevel_2 = getDecorUpgradeCount(2);
decorLevel_3 = getDecorUpgradeCount(3);
--DebugOut("values:"..decorLevel_1..", "..decorLevel_2..", "..decorLevel_3);


------ define X-alignment positions -------
element1posX = kCenter + 10 - 180;
element2posX = kCenter + 10      ;
element3posX = kCenter + 10 + 180;
---------------------------------------------------

imageStarsOn  = "gamepiece/star_full";
imageStarsOff = "gamepiece/star_notfull";
starSpacingX  = 20;

vClickDone = true;

MakeDialog
{
	DecorUpgradesWindow
	{
		x   		= kCenter,
		y   		= kCenter,
		fit 		= true,
		fadeSpeed	= 1.75;
		w			= 800,
		h 			= 600,
		
		Bitmap
		{
			-- Name the modal dialog ----------------------------------------------------------------
			name 	= "decors",
			x	 	= kCenter,
			y	 	= kCenter,
			
			-- BACKGROUND IMAGE ---------------------------------------------------------------
			image	= "backgrounds/upgrades_background",
			x		= kCenter,
			y		= kCenter - 20, --+ (kButtonSpacing * 1),
		},
			
			-- TITLE -----------------------------------------------------------------------------------
			SetStyle(ButtonStyle),
			Text
			{
				x		= kCenter,
				y		= kButtonY - 140,
				w		= 300,
				h		= 100,
				flags 	= kVAlignCenter + kHAlignCenter,
				label 	= "decor_upgrades_title",
				font    = TitleUpgradesFont,
			},
			
			-- DECORATION UPGRADE  IMAGE (((1))) ------------------------------------------
			SetStyle(DecorButtonStyle1),
			DecorButton
			{
				x				= element1posX,
				y				= graphicElementsY,
				name			= "decorOption1",
				textureover		= "buttons/myovertexture",
				texturepressed	= "buttons/mypressedtexture",
				--close			= (decorLevel_1 < 2),
				decorText		= decor_upgrade[1],
				decorLevel		= decorLevel_1,
				command 		= function()
									if ( decorLevel_1 < 2 ) then
										if ( vClickDone == false ) then
											vClickDone = true;
											selectDecorOption(1);
											FadeOutAndClose();
										end
									end
								  end
			},	
			
			-- DECORATION UPGRADE  IMAGE (((2))) --------------------------------------------
			SetStyle(DecorButtonStyle2),		
			DecorButton
			{
				x				= element2posX,
				y 				= graphicElementsY,
				name			= "decorOption2",
				textureover		= "buttons/myovertexture",
				texturepressed	= "buttons/mypressedtexture",
				--close			= (decorLevel_2 < 2),
				decorText		= decor_upgrade[2],
				decorLevel		= decorLevel_2,
				command 		= function()
									if ( decorLevel_2 < 2 ) then
										if ( vClickDone == false ) then
											vClickDone = true;
											selectDecorOption(2);
											FadeOutAndClose();
										end
									end
								  end
			},		
			
			-- DECORATION UPGRADE  IMAGE (((3))) ---------------------------------------
			SetStyle(DecorButtonStyle3),	
			DecorButton
			{
				x 				= element3posX,
				y 				= graphicElementsY,
				name			= "decorOption3",
				textureover		= "buttons/myovertexture",
				texturepressed	= "buttons/mypressedtexture",
				--close			= (decorLevel_3 < 2),
				decorText		= decor_upgrade[3],
				decorLevel		= decorLevel_3,
				command			= function()
									if ( decorLevel_3 < 2 ) then
										if ( vClickDone == false ) then
											vClickDone = true;
											selectDecorOption(3);
											FadeOutAndClose();
										end
									end
								  end
			},
			
			
			--- SELECION GRAPHICS -----------------------------------------------------
			Bitmap 
			{
				name	= "overlaySelection1";
				x		= element1posX,
				y 		= graphicElementsY,
				image 	= "icons/genericselect";
			},
			Bitmap 
			{
				name	= "overlaySelection2";
				x		= element2posX,
				y 		= graphicElementsY,
				image 	= "icons/genericselect";
			},
			Bitmap 
			{
				name	= "overlaySelection3";
				x		= element3posX,
				y 		= graphicElementsY,
				image 	= "icons/genericselect";
			},
			
			-- GENERIC TEXT ((((1))))------------------------------------------------------
			SetStyle(ButtonStyle),
			Text
			{
				x 		= kCenter,
				y 		= textElementsY,
				w		= 460,
				h		= 80,
				flags 	= kVAlignCenter + kHAlignCenter,
				name	= "generictext1";
				text    = "";
				font	= StandardButtonFont2,
			},
			
			
			---- STARS!!! 1---( ON FIRST )-------------------------------------------------------------------
			Bitmap 
			{
				name	= "imgstaron_A_1";
				x		= element1posX - starSpacingX,
				y 		= starsPosY,
				image 	= imageStarsOn;
			},
			Bitmap 
			{
				name	= "imgstaron_A_2";
				x		= element1posX + starSpacingX,
				y 		= starsPosY,
				image 	= imageStarsOn;
			},
			Bitmap 
			{
				name	= "imgstaron_B_1";
				x		= element2posX - starSpacingX,
				y 		= starsPosY,
				image 	= imageStarsOn;
			},
			Bitmap 
			{
				name	= "imgstaron_B_2";
				x		= element2posX + starSpacingX,
				y 		= starsPosY,
				image 	= imageStarsOn;
			},
			Bitmap 
			{
				name	= "imgstaron_C_1";
				x		= element3posX - starSpacingX,
				y 		= starsPosY,
				image 	= imageStarsOn;
			},
			Bitmap 
			{
				name	= "imgstaron_C_2";
				x		= element3posX + starSpacingX,
				y 		= starsPosY,
				image 	= imageStarsOn;
			},
			
			---- STARS part 2 !!! ---( OFF  )-------------------------------------------------------------------
			Bitmap 
			{
				name	= "imgstaroff_A_1";
				x		= element1posX - starSpacingX,
				y 		= starsPosY,
				image 	= imageStarsOff;
			},
			Bitmap 
			{
				name	= "imgstaroff_A_2";
				x		= element1posX + starSpacingX,
				y 		= starsPosY,
				image 	= imageStarsOff;
			},
			Bitmap 
			{
				name	= "imgstaroff_B_1";
				x		= element2posX - starSpacingX,
				y 		= starsPosY,
				image 	= imageStarsOff;
			},
			Bitmap 
			{
				name	= "imgstaroff_B_2";
				x		= element2posX + starSpacingX,
				y 		= starsPosY,
				image 	= imageStarsOff;
			},
			Bitmap 
			{
				name	= "imgstaroff_C_1";
				x		= element3posX - starSpacingX,
				y 		= starsPosY,
				image 	= imageStarsOff;
			},
			Bitmap 
			{
				name	= "imgstaroff_C_2";
				x		= element3posX + starSpacingX,
				y 		= starsPosY,
				image 	= imageStarsOff;
			},
		-- },
	},
}

if gMode == "story" then
	GameInPauseDialog(false, false);
else 
	GameInPauseDialog(false, true);
end

